﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Collections;

namespace Chapter_04
{
    class Customer
    {
        public string Name;
    }

    class PotentialCustomer : Customer
    {
        public string SalesPerson;
    }

    class RegularCustomer : Customer
    {
        public DateTime LastPurchase;
    }

    struct Money
    {
        public decimal Amount;
    }

    class Program
    {
        static void Main(string[] args)
        {
            // obiekt programowania szablonowego

            decimal amount = 3.50m;
            object obj1 = amount;
            Customer cust = new Customer();
            object obj2 = cust;

            Customer cust2 = (Customer)obj2;

            // Typy ArrayList i referencyjne

            ArrayList customers = new ArrayList();

            Customer cust3 = new Customer();
            cust3.Name = "Jan Kowalski";
            Customer cust4 = new Customer();
            cust4.Name = "Janina Nowak";

            customers.Add(cust3);
            customers.Add(cust4);

            foreach (Customer custItem in customers)
            {
                Console.WriteLine("Nazwa klienta: {0}", custItem.Name);
            }

            decimal amountIn = 3.50m;
            object obj = amountIn; // opakowywanie
            decimal amountOut = (decimal)obj; // rozpakowywanie

            // Typy ArrayList i wartościowe
            ArrayList prices = new ArrayList();

            decimal amount1 = 7.50m;
            decimal amount2 = 1.95m;
            prices.Add(amount1);
            prices.Add(amount2);

            foreach (decimal amountItem in prices)
            {
                Console.WriteLine("Ilość: {0}", amountItem);
            }

            // Przypisanie dla typu referencyjnego

            Customer cust5 = new Customer();
            cust5.Name = "Jan Kowalski";
            Customer cust6 = new Customer();
            cust6.Name = "Janina Nowak";

            Console.WriteLine("Przed przypisaniem typu referencyjnego:");
            Console.WriteLine("cust5: {0}", cust5.Name);
            Console.WriteLine("cust6: {0}", cust6.Name);

            cust5 = cust6;

            Console.WriteLine("Po przypisaniu typu referencyjnego:");
            Console.WriteLine("cust5: {0}", cust5.Name);
            Console.WriteLine("cust6: {0}", cust6.Name);

            cust6.Name = "Jan Kowalski";

            Console.WriteLine("Po modyfikacji zawartości obiektu o typie referencyjnym:");
            Console.WriteLine("cust5: {0}", cust5.Name);
            Console.WriteLine("cust6: {0}", cust6.Name);

            // Przypisanie dla typu wartościowego

            Money cash1;
            Money cash2;

            cash1.Amount = 50.00m;
            cash2.Amount = 75.00m;

            Console.WriteLine("Przed przypisaniem wartości:");
            Console.WriteLine("cash1.Amount: {0}", cash1.Amount);
            Console.WriteLine("cash2.Amount: {0}", cash2.Amount);

            cash1 = cash2;

            Console.WriteLine("Po przypisaniu wartości:");
            Console.WriteLine("cash1.Amount: {0}", cash1.Amount);
            Console.WriteLine("cash2.Amount: {0}", cash2.Amount);

            cash2.Amount = 50.00m;

            Console.WriteLine("Po modyfikacji zawartości obiektu o typie wartościowym:");
            Console.WriteLine("cash1.Amount: {0}", cash1.Amount);
            Console.WriteLine("cash2.Amount: {0}", cash2.Amount);

            // Identyfikatory GUID

            Guid uniqueVal1 = new Guid();
            Console.WriteLine("uniqueVal1: {0}", uniqueVal1.ToString());

            uniqueVal1 = new Guid("89e9f11b-00ee-47dc-be15-01f70eeac3f9");
            Console.WriteLine("uniqueVal1: {0}", uniqueVal1.ToString());
            
            uniqueVal1 = Guid.NewGuid();
            Console.WriteLine("uniqueVal1: {0}", uniqueVal1.ToString());

            // DateTime's

            DateTime date = new DateTime();
            Console.WriteLine("Data: {0}", date);

            date = new DateTime(2008, 7, 4, 21, 35, 15, 777);

            Console.WriteLine("Data: {0}", date);

            date = DateTime.Now;
            Console.WriteLine("Data: {0}", date);

            Console.WriteLine("{0} {1}. dzień miesiąca jest {2}. dniem roku",
                date.DayOfWeek, date.Day, date.DayOfYear);


            Console.WriteLine("Data przed wywołaniem AddDays(1): {0}", date);
            date.AddDays(1);
            Console.WriteLine("Data po wywołaniu AddDays(1): {0}", date);

            Console.WriteLine("Data przed wywołaniem AddDays(1): {0}", date);
            date = date.AddDays(1);
            Console.WriteLine("Data po wywołaniu AddDays(1): {0}", date);

            int testIterations = 5; // int.MaxValue / 4;
            DateTime start = DateTime.Now;

            for (int i = 0; i < testIterations; i++)
            {
                Money cash;
                cash.Amount = decimal.MaxValue;
            }

            DateTime finish = DateTime.Now;
            TimeSpan elapsedTime = finish - start;

            Console.WriteLine("Czas trwania: {0}", elapsedTime);

            Console.Write("Wprowadź datę (dd.mm.rrrr): ");
            string dateStr = Console.ReadLine();

            date = DateTime.Parse(dateStr);

            Console.WriteLine("Wprowadziłeś '{0}'", date);

            Console.WriteLine("Tylko data: {0:d}", date);
            Console.WriteLine("Tylko data: {0}", date.ToString("d"));

            date = new DateTime(2008, 7, 4, 21, 35, 15, 777);
            
            Console.WriteLine("d: {0:d}", date);
            Console.WriteLine("D: {0:D}", date);
            Console.WriteLine("t: {0:t}", date);
            Console.WriteLine("T: {0:T}", date);
            Console.WriteLine("f: {0:f}", date);
            Console.WriteLine("F: {0:F}", date);
            Console.WriteLine("g: {0:g}", date);
            Console.WriteLine("G: {0:G}", date);
            Console.WriteLine("m: {0:m}", date);
            Console.WriteLine("M: {0:M}", date);
            Console.WriteLine("r: {0:r}", date);
            Console.WriteLine("R: {0:R}", date);
            Console.WriteLine("s: {0:s}", date);
            Console.WriteLine("u: {0:u}", date);
            Console.WriteLine("U: {0:U}", date);
            Console.WriteLine("y: {0:y}", date);
            Console.WriteLine("Y: {0:Y}", date);

            Console.WriteLine("mm.dd.rr: {0:MM.dd.yy}", date);

            // Typy puste

            DateTime? createDate = null;

            bool isNull;

            isNull = createDate == null;
            isNull = createDate.HasValue;

            if (createDate == null)
            {
                createDate = DateTime.Now;
            }

            createDate = createDate ?? DateTime.Now;

            DateTime? defaultDate = null;

            createDate = createDate ?? defaultDate ?? DateTime.Now;
        }
    }
}
